
#include "USB_PD.H"


//-----------------------------------------------------------------------------
// init UART1 BMC mode
//-----------------------------------------------------------------------------
void UART1_BMC_mode()
{
    SFRPI = S1CON_Page;
    SM01 = 1;
    SM11 = 0;
    REN1 = 1;
    SFRPI = S1CFG_Page;
    S1CFG |= SM31;
    S1CFG &= ~S1TME;
    SFRPI = 0;
}
//-----------------------------------------------------------------------------
//  UART1 Baud Rate
//-----------------------------------------------------------------------------
void UART1_Set_BaudRate()
{
    SFRPI = S1CFG_Page;
    S1CFG |= S1TX12 | S1MOD1;

    SFRPI = S1BRT_Page;
    S1BRT = S1BRC = 246;  //300K

    SFRPI = S1CFG_Page;
    S1CFG |= S1TR;

    SFRPI = 0;
}
//-----------------------------------------------------------------------------
// UART1 BMC bit mode
//-----------------------------------------------------------------------------
void UART1_BMCMode_Select ( UART1_BMCMode_Def MODE_SELECT )
{
    SFRPI = S1CFG6_Page;

    if ( MODE_SELECT == BMC_5bit )
        S1CFG6 |= M6PDE1;
    else
        S1CFG6 &= ~M6PDE1;

    SFRPI = 0;
}



//-----------------------------------------------------------------------------
// Initial UART1
//-----------------------------------------------------------------------------
void Initial_UART1()
{
    UART1_BMC_mode();           //UART1 = BMC mode(USB PD)
    UART1_Set_BaudRate();       //Baud Rate 300K
    UART1_BMCMode_Select ( BMC_5bit );
    EIP1L |= PS1L;
    EIP1H |= PS1H;      //UART1 Interrupt Priority highest

    EA = 1;
}
